#!/bin/bash
#SBATCH --job-name=train_all_ratios
#SBATCH --partition=v100
#SBATCH --array=0-5
#SBATCH --nodes=1    
#SBATCH --ntasks=1
#SBATCH --gres=gpu:1
#SBATCH --output=logs/output_%x_%a.txt

METHOD='Diffusion'
NUM_SHADOW=64
TRAIN_DATASET_SIZES=(1 3 5 10 15 20)
echo "Train with Dataset Size: ${TRAIN_DATASET_SIZES[$SLURM_ARRAY_TASK_ID]}x"

exp_id=0
python train.py \
    --exp_id $exp_id \
    --num_shadow $NUM_SHADOW \
    --data_path datasets \
    --lira_path experiments/diffusion_all_ratios \
    --epochs 300 \
    --lr_net 0.1 \
    --model_type ResNet18 \
    --method $METHOD \
    --num_canaries 500 \
    --syn_data_path ../Diffusion/syn_images \
    --trainset_size ${TRAIN_DATASET_SIZES[$SLURM_ARRAY_TASK_ID]}
